<?php

if (isset($_GET['bin'])) {
    $bin = $_GET['bin'];

    $cardBIN = substr(filter_var($bin, FILTER_SANITIZE_STRING), 0, 6);

    $url = "https://data.handyapi.com/bin/" . $cardBIN;
    
    $options = [
        "http" => [
            "method" => "GET",
        ]
    ];
    
    $context = stream_context_create($options);
    
    $response = @file_get_contents($url, false, $context);

    if ($response !== false) {
        $data = @json_decode($response, true);

        if ($data !== null) {
            header('Content-Type: application/json');
            echo json_encode($data, JSON_PRETTY_PRINT);
        } else {
            echo 'Error parsing JSON response.';
        }
    } else {
        echo 'Error fetching data from API.';
    }
} 
else {
    echo 'Parameter Bin tidak ditemukan dalam request.';
}
?>